<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  Copyright (c) 2023 Open LMS (https://www.openlms.net)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = '關於此課程';
$string['activity'] = '活動';
$string['action:changeassetvisibility'] = '變更資產可見性';
$string['action:duplicateasset'] = '複製資產';
$string['action:changesectionvisibility'] = '變更章節可見性';
$string['action:highlightsectionvisibility'] = '反白顯示章節可見性';
$string['action:sectiontoc'] = '取得章節目錄';
$string['addanewsection'] = '建立新單元';
$string['addresourceoractivity'] = '建立學習活動';
$string['admin'] = '管理';
$string['advancedbrandingheading'] = '進階品牌塑造';
$string['ago'] = '之前';
$string['answered'] = '已回答';
$string['appendices'] = '工具';
$string['arialabelnewsarticle'] = '新聞文章';
$string['assigndraft'] = '草稿需要確認';
$string['assignreopened'] = '已重新開啟';
$string['at'] = '於';
$string['attempted'] = '已嘗試';
$string['basics'] = '基本資料';
$string['brandingheading'] = '品牌塑造';
$string['browse'] = '瀏覽';
$string['browseallcourses'] = '瀏覽所有課程';
$string['cachedef_activity_deadlines'] = '使用者活動截止日期的快取存放區。';
$string['cachedef_generalstaticappcache'] = 'Snap 一般靜態應用程式層級快取';
$string['cachedef_course_completion_progress'] = '這會用來依據課程 / 使用者快取進度資料。';
$string['cachedef_course_completion_progress_ts'] = '如果課程或模組的進度設定改變，我們可以用此方式使工作階段層級快取失效。';
$string['cachedef_webservicedefinitions'] = '快取自動產生的 Web 服務定義。';
$string['card'] = '卡片';
$string['categoryedit'] = '編輯類別';
$string['category_color'] = '類別顏色';
$string['category_color_description'] = '課程類別顏色。子課程會採用最接近的上層類別配置';
$string['category_color_palette'] = '調色板';
$string['category_color_palette_description'] = '查看所指顏色對應的十六進位值。這不會
影響任何配置，僅做為範例來幫助使用者建立配置值。';
$string['changecoverimage'] = '變更封面影像';
$string['changefullname'] = '變更網站名稱';
$string['chapters'] = '章節';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></div>';
$string['close'] = '關閉';
$string['conditional'] = '條件式';
$string['contents'] = '內容';
$string['contributed'] = '已發表';
$string['courses'] = '課程';
$string['coursecontacts'] = '課程聯絡人';
$string['coursedisplay'] = '課程顯示';
$string['coursefootertoggle'] = '課程頁尾';
$string['coursefootertoggledesc'] = '課程頁尾會在課程頁面中向使用者顯示實用資訊，包括課程聯絡人、課程描述和課程近期活動。';
$string['courseformatnotification'] = 'Snap 主題無法完整支援您目前使用的課程格式。為了享有最佳使用體驗，Open LMS 建議您針對 Snap 主題使用主題或每週課程格式。您可以在<a href="{$a}">課程設定</a>中變更課程格式。';
$string['coursefixydefaulttext'] = '您目前沒有註冊任何課程。<br>您註冊的課程會顯示在這裡。';
$string['coursegrade'] = '課程成績：';
$string['coursepartialrender'] = '啟用延遲載入課程區段';
$string['coursepartialrenderdesc'] = '若啟用，課程區段會在使用者選取時隨需載入。如此有助於加快載入有大量內容的課程。';
$string['coursenavigation'] = '課程瀏覽';
$string['coursesummaryfilesunsuitable'] = '請先清空您的課程摘要檔案，再嘗試變更封面影像';
$string['courseactivitieslabel'] = '章節活動';
$string['coursetools'] = '課程儀表板';
$string['coverdisplay'] = '封面顯示';
$string['covercarousel'] = '封面浮動切換';
$string['covercarouselon'] = '使用封面浮動切換';
$string['covercarouseldescription'] = '<p>浮動切換是一組旋轉顯示的橫幅或投影片，顯示於您網站的首頁，取代封面影像。</p>
<p>最多新增 3 個影像，每一張投影片有一個標題，和一個可選副標題。1200 x 600 像素的影像效果最佳。</p>';
$string['covercarouselsronly'] = '這是自動旋轉顯示投影片的浮動切換。啟動任何按鈕即可停用旋轉顯示。使用下一張和上一張按鈕即可瀏覽，或使用投影片圓點前往投影片。';
$string['covercarouselplaybutton'] = '繼續浮動切換自動旋轉顯示投影片。';
$string['covercarouselpausebutton'] = '暫停浮動切換自動旋轉顯示投影片。';
$string['coverimage'] = '封面影像';
$string['covervideo'] = '封面影片';
$string['comingsoon'] = '即將推出！';
$string['createsection'] = '建立單元';
$string['current'] = '目前';
$string['customcss'] = '自訂 CSS';
$string['customcssdesc'] = '請注意，掌握越大的權力，也意味著承擔更大的責任。您須負責解決這裡新增的 CSS 所造成的任何問題。Open LMS 支援不對 CSS 相關內容進行疑難排解，亦不提供任何協助。';
$string['customtopbar'] = '瀏覽列';
$string['customisenavbar'] = '變更瀏覽列色彩';
$string['customisenavbutton'] = '變更我的課程按鈕的色彩';
$string['customisecustommenu'] = '變更自訂功能表文字顏色';
$string['custommenutext'] = '自訂功能表文字顏色';
$string['deadlines'] = '截止時間';
$string['deadlinestoggle'] = '截止時間';
$string['deadlinestoggledesc'] = '對使用者顯示已註冊課程的任何近期活動截止日期。';
$string['defaultsummary'] = '請利用此區域說明主題內容，可使用文字、影像、音訊和視訊。';
$string['defaultintrosummary'] = '歡迎來到您的新課程 {$a}。
<br>首先請使用文字、影像、音訊和視訊描述您的課程內容。';
$string['defaulttopictitle'] = '未命名的主題';
$string['debugerrors'] = '除錯錯誤';
$string['deleteassetconfirm'] = '刪除 {$a}';
$string['deletingasset'] = '正在刪除 {$a}';
$string['deletingassetname'] = '正在刪除「{$a->name}」{$a->type}';
$string['deletesectionconfirm'] = '刪除章節';
$string['deletingsection'] = '正在刪除「{$a}」章節';
$string['draft'] = '未向學員發佈';
$string['dropzonelabel'] = '拖放檔案以附加檔案或<span class="fake-link">瀏覽</span>';
$string['due'] = '{$a} 到期';
$string['edit'] = '編輯「{$a}」';
$string['editcoursecontent'] = '編輯區塊';
$string['editcoursesettings'] = '課程設定';
$string['editcoursetopic'] = '編輯章節';
$string['editcustomfooter'] = '編輯頁尾';
$string['editcustommenu'] = '編輯自訂功能表';
$string['error'] = '錯誤';
$string['errorgettingfeed'] = '取得摘要項目時發生錯誤。';
$string['error:categorycolorinvalidjson'] = '課程類別的 JSON 格式不正確';
$string['error:categorycolorinvalidvalue'] = '類別「{$a}」的記錄編號或顏色值無效';
$string['error:categorynotfound'] = '未找到編號「{$a}」的類別記錄';
$string['error:coverimageexceedsmaxbytes'] = '封面影像超出網站層級允許的檔案大小上限 ({$a})';
$string['error:coverimageresolutionlow'] = '為獲得最佳品質，我們建議使用更大的影像，寬度至少 1024px。';
$string['error:duplicatedcategoryids'] = 'JSON 格式不正確，部分編號重複';
$string['error:failedtochangeassetvisibility'] = '隱藏/顯示資產失敗';
$string['error:failedtochangesectionvisibility'] = '隱藏/顯示章節失敗';
$string['error:failedtohighlightsection'] = '反白顯示章節失敗';
$string['error:failedtoduplicateasset'] = '複製失敗';
$string['error:failedtodeleteasset'] = '刪除資產失敗';
$string['error:failedtotoc'] = '取得目錄失敗。';
$string['extension'] = '延伸 {$a}';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = '您的 Facebook 頁面 URL。';
$string['favicon'] = '最愛圖示';
$string['favicondesc'] = '常用圖示會出現在網頁瀏覽器的網址列、使用者的書籤和行動捷徑中。';
$string['favorite'] = '常用 {$a}';
$string['favorited'] = '已加入常用項目 {$a}';
$string['featurespots'] = '重要特性';
$string['featurespotsedit'] = '編輯重要特性';
$string['featurespotshelp'] = '<p>最多可新增 3 個重要特性至您網站的首頁，以向目前和潛在使用者強調主要優勢。</p>
<p>為每個特性新增標題、內容及可選影像。影像應為正方形，且不可大於 200px x 200px。</p>';
$string['featurespotsheading'] = '重要特性標題';
$string['featureonetitle'] = '特性 1 標題';
$string['featuretwotitle'] = '特性 2 標題';
$string['featurethreetitle'] = '特性 3 標題';
$string['featureonetitlelink'] = '特性 1 標題連結';
$string['featuretwotitlelink'] = '特性 2 標題連結';
$string['featurethreetitlelink'] = '特性 3 標題連結';
$string['featuretitlelinkdesc'] = '輸入要連結此重要特性的 URL。您可以在網站內新增外部或內部連結。若要新增內部連結，請複製包含「/」在內的網站 URL。例如，若要新增課程連結，可使用「/course/view.php?id=160」。若要新增外部連結，則以 https:// 作為連結開頭';
$string['featureonetitlecb'] = '特性 1 在新視窗開啟';
$string['featuretwotitlecb'] = '特性 2 在新視窗開啟';
$string['featurethreetitlecb'] = '特性 3 在新視窗開啟';
$string['featuretitlecbdesc'] = '若啟用，新增至重要特性的連結將會在新視窗開啟。';
$string['featureonetext'] = '特性 1 內容';
$string['featuretwotext'] = '特性 2 內容';
$string['featurethreetext'] = '特性 3 內容';
$string['featureoneimage'] = '特性 1 影像';
$string['featuretwoimage'] = '特性 2 影像';
$string['featurethreeimage'] = '特性 3 影像';
$string['featuredcourses'] = '精選課程';
$string['featuredcourseshelp'] = '在您網站的首頁上強調最多 8 門精選課程。輸入課程編號即可將課程設為精選課程。';
$string['featuredcoursesheading'] = '精選課程標題';
$string['featuredcourseone'] = '精選課程 1';
$string['featuredcoursetwo'] = '精選課程 2';
$string['featuredcoursethree'] = '精選課程 3';
$string['featuredcoursefour'] = '精選課程 4';
$string['featuredcoursefive'] = '精選課程 5';
$string['featuredcoursesix'] = '精選課程 6';
$string['featuredcourseseven'] = '精選課程 7';
$string['featuredcourseeight'] = '精選課程 8';
$string['featuredcoursesedit'] = '編輯精選課程';
$string['featuredcoursesbrowseall'] = '瀏覽所有課程';
$string['featuredcoursesbrowsealldesc'] = '新增瀏覽所有課程連結';
$string['feedbackavailable'] = '可用意見回應';
$string['feedbacktoggle'] = '意見回應和評分';
$string['feedbacktoggledesc'] = '向學習者顯示其最近的意見回應，以及向講師顯示需要評分的最近送出項目。';
$string['footnote'] = '網站頁尾';
$string['footnotedesc'] = '頁尾會跨整個網站顯示。這裡最適合放置說明、支援和您組織擁有的任何其他網站連結，方便您與學習者和講師分享。例如，圖書館或電子郵件地址。';
$string['forcepwdwarningpersonalmenu'] = '您必須先<a href="{$a}">變更密碼</a>才能使用個人功能表。';
$string['forumauthor'] = '作者';
$string['forumlastpost'] = '最新文章';
$string['forumpicturegroup'] = '群組';
$string['forumreplies'] = '回應';
$string['forumtopic'] = '主題';
$string['forumposts'] = '論壇文章';
$string['forumpoststoggle'] = '論壇文章';
$string['forumpoststoggledesc'] = '向使用者顯示其課程中最近發表的 10 篇論壇文章';
$string['fullname'] = '網站名稱';
$string['fullnamedesc'] = '網站的名稱。';
$string['graderadviseuserreport'] = '在行動裝置上無法正常使用「評分者報告」，建議改用「使用者報告」';
$string['grading'] = '評分';
$string['help'] = '說明';
$string['helpguide'] = '說明指南';
$string['headingfont'] = '標題字型';
$string['headingfont_desc'] = '這個 sans-serif 字型用於整個網站中的標題 (h1 - h6 元素)。如果您使用自訂的網頁字型，請記得將其新增至 Moodle 額外 HTML 中。若要修改其他元素的字型，請善用自訂 CSS 選項，如需該選項的使用範例，請參考這份<a href="https://help.openlms.net/en/administrator/manage-a-site/snap-font-family-with-custom-css/" target="_blank">文件</a>中的相關說明。';
$string['helpwithlogin'] = '登入說明';
$string['helpwithloginandguest'] = '登入/訪客存取說明';
$string['hiddencoursestoggle'] = '隱藏的課程';
$string['highlightedsection'] = '已反白顯示';
$string['home'] = '首頁';
$string['image'] = '影像';
$string['images'] = '影像';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = '您的 Instagram 帳戶 URL。';
$string['introduction'] = '介紹';
$string['jsontext'] = 'JSON 文字';
$string['jsontextdescription'] = '文字區域會驗證特定 JSON，因此僅允許現有類別，
僅有作為編號紀錄 (類別紀錄) 的數值有效，且僅接受十六進位值作為顏色。
範例如下：<br>
{"1":"#FAAFFF"、<br>
"45":"#AFF"、<br>
"65":"#FFF228"、<br>
"12":"#CC0084"、<br>
"56":"#CC0087"、<br>
"89":"#CCF084"}';
$string['knowledgebase'] = 'Open LMS 知識庫';
$string['list'] = '清單';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = '您組織的 LinkedIn url。';
$string['leftnav'] = '目錄';
$string['leftnavdesc'] = '選取要顯示目錄的位置。清單提供較多空間來顯示內容，對於有許多主題的課程來說最為理想。';
$string['loading'] = '正在載入...';
$string['loggedinasguest'] = '您已使用訪客身分登入';
$string['loggedoutmsg'] = '您目前已登出。如果您想要繼續使用此網站，請再次登入。';
$string['loggedoutmsgtitle'] = '您已登出';
$string['loggedoutfailmsg'] = '您必須登入 {$a}。';
$string['loginform'] = '登入';
$string['logo'] = '標誌';
$string['logodesc'] = '您的標誌會顯示在整個網站的頁首中。';
$string['menu'] = '我的課程';
$string['messageread'] = '訊息已讀';
$string['messages'] = '訊息';
$string['messagestoggle'] = '訊息';
$string['messagestoggledesc'] = '向使用者顯示過去 12 週收到的最新訊息。';
$string['more'] = '更多';
$string['morenews'] = '更多新聞';
$string['movingstartedhelp'] = '瀏覽至您要放置單元「{$a}」的位置';
$string['movingdropsectionhelp'] = '將單元「{$a->moving}」放置在單元「{$a->before}」之前';
$string['moving'] = '正在移動「{$a}」';
$string['movingcount'] = '正在移動 {$a} 個物件';
$string['movefailed'] = '「{$a}」移動失敗';
$string['move'] = '移動「{$a}」';
$string['movehere'] = '移到這裡';
$string['movesection'] = '移動單元';
$string['navbarbg'] = '背景顏色';
$string['navbarlink'] = '文字顏色';
$string['navbarbuttoncolor'] = '背景顏色';
$string['navbarbuttonlink'] = '文字顏色';
$string['nextsection'] = '下一章節';
$string['nodeadlines'] = '您沒有將到來的截止時間。';
$string['noforumposts'] = '您沒有相關論壇文章。';
$string['nograded'] = '您沒有近期意見回應。';
$string['nograding'] = '您沒有要評分的送出內容。';
$string['nomessages'] = '您沒有訊息。';
$string['notanswered'] = '未回答';
$string['notattempted'] = '未嘗試';
$string['notcontributed'] = '未發表';
$string['notpublished'] = '未向學員發佈';
$string['notsubmitted'] = '未送出';
$string['overdue'] = '過期';
$string['personalmenu'] = '個人功能表';
$string['personalmenufeatures'] = '個人功能表功能';
$string['personalmenulogintoggle'] = '登入時顯示個人功能表';
$string['personalmenulogintoggledesc'] = '登入後立即開啟個人功能表';
$string['personalmenuadvancedfeedsenable'] = '啟用進階摘要';
$string['personalmenuadvancedfeedsenabledesc'] = '進階摘要會載入一些私人功能表項目，以便加快載入的時間，並隨需重新整理內容。';
$string['personalmenuadvancedfeedsperpage'] = '進階摘要項目顯示計數';
$string['personalmenuadvancedfeedsperpagedesc'] = '選擇摘要中要顯示的項目數。使用者可以選取<strong>檢視更多</strong>來顯示其他項目。';
$string['personalmenuadvancedfeedslifetime'] = '進階摘要存留期';
$string['personalmenuadvancedfeedslifetimedesc'] = '選擇登入後在瀏覽器中快取摘要的時間長度。將值設定為 0，就不會在瀏覽器中快取摘要。';
$string['personalmenurefreshdeadlines'] = '使用已排程的工作重新整理截止時間。';
$string['personalmenurefreshdeadlinesdesc'] = '工作執行時，截止時間資料將重新整理，以更快載入頁面。';
$string['pld'] = 'PLD';
$string['pluginname'] = 'Snap';
$string['poster'] = '封面影像';
$string['posterdesc'] = '用於網站首頁的大型標題影像。橫向影像 (1200 x 600 像素或更大) 效果最佳。';
$string['poweredbyrunby'] = '採用 <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a>，
其為 <a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a> 產品。<br>
版權所有 © {$a->year} Open LMS，保留所有權利。';
$string['previoussection'] = '上一單元';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = '使用者已加入常用項目之課程的課程編號';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = '將課程加入常用項目之使用者的使用者編號';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = '使用者將課程加入常用項目時的時間戳記';
$string['privacy:metadata:theme_snap_course_favorites'] = '儲存使用者的 Snap 課程常用項目';
$string['problemsfound'] = '找到的問題';
$string['progress'] = '進度';
$string['readmore'] = '閱讀更多資訊 »';
$string['recentactivity'] = '近期活動';
$string['recentfeedback'] = '意見回應';
$string['region-main'] = '主區域';
$string['region-side-main-box'] = '主區域';
$string['region-side-post'] = '右側';
$string['region-side-pre'] = '左側';
$string['region-side-top'] = '頂端';
$string['released'] = '已發行：{$a}';
$string['reopened'] = '已重新開啟';
$string['resourcedisplay'] = '資源顯示';
$string['resourcedisplayhelp'] = '選取附件和連結在課程中顯示的方式。在小型活動和資源卡描述中，Snap 主題不支援多媒體檔案。';
$string['displaydescription'] = '顯示說明';
$string['displaydescriptionhelp'] = '選取此選項，以首先在新頁面中顯示資源和 URL 活動的說明。學員將從說明中存取內容。';
$string['search'] = '搜尋內容';
$string['showcoursegradepersonalmenu'] = '成績';
$string['showcoursegradepersonalmenudesc'] = '在個人功能表的課程卡片中，向使用者顯示其成績';
$string['socialmedia'] = '社交媒體';
$string['submitted'] = '已送出';
$string['sitedescription'] = '網站描述';
$string['subtitle'] = '副標題';
$string['subtitle_desc'] = '對使用者簡單描述您的網站。';
$string['summarylabel'] = '章節摘要';
$string['themecolor'] = '網站顏色';
$string['themecolordesc'] = '亮色系的效果最好，讓您的網站具有現代感。';
$string['title'] = '頭銜';
$string['top'] = '頂端';
$string['topbarbgcolor'] = '瀏覽列顏色';
$string['topbarlinkcolor'] = '瀏覽列連結和圖示顏色';
$string['topbarbuttoncolor'] = '我的課程背景';
$string['togglenavigation'] = '切換瀏覽';
$string['topicactions'] = '主題動作';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = '您的 Twitter 帳戶 URL。';
$string['unenrolme'] = '將我取消註冊';
$string['enrolme'] = '為我註冊';
$string['unread'] = '未讀';
$string['unsupportedcoverimagetype'] = '不支援的封面影像類型 ({$a})';
$string['via'] = '經由';
$string['viewcourse'] = '檢視課程';
$string['viewmore'] = '觀看更多';
$string['viewyourprofile'] = '檢視您的資訊';
$string['viewmyfeedback'] = '檢視我的意見回應';
$string['viewcalendar'] = '檢視我的行事曆';
$string['viewforumposts'] = '檢視我的論壇文章';
$string['viewmessaging'] = '檢視我的訊息';
$string['vieworiginalimage'] = '檢視原始影像';
$string['visibility'] = '可見性';
$string['xofyanswered'] = '{$a->completed}/{$a->participants} 已回答';
$string['xofyattempted'] = '{$a->completed}/{$a->participants} 已嘗試';
$string['xofycontributed'] = '{$a->completed}/{$a->participants} 已發表';
$string['xofysubmitted'] = '{$a->completed}/{$a->participants} 已送出';
$string['xungraded'] = '{$a} 個未評分';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = '您的 YouTube 頻道 URL。';
$string['showallsectionsdisabled'] = '由於設計語言的關係，無法在 Snap 中使用「在一個頁面上顯示全部章節」。';
$string['disabled'] = '已停用';
$string['showappearancedisabled'] = 'Snap 的設計語言會防止變更「外觀」設定。';
$string['pbb'] = '以資訊為基礎的品牌塑造';
$string['pbb_description'] = '啟用<strong>以資訊為基礎的品牌塑造</strong>後，您可以根據所選的使用者資訊欄位，為特定小組的使用者自訂品牌塑造體驗。
<ul><li>系統會將使用者欄位值<em>轉換為 slug 格式</em>；將所有字元轉換為小寫，並以連接符號 (-) 分隔</li>
<li>將在前面加上字串 <code>snap-pbb-</code></li>
<li>此類別將新增至 <code>body</code> Html 標籤</li></ul>
例如，系統會將使用者欄位值 <em>Blueberry Extravaganza</em> 轉換為 slug 格式，改為 <code>snap-pbb-blueberry-extravaganza</code><br /><br />
此功能與自訂 CSS 一起使用，您將必須使用<a class="snap-settings-tab-link" href="#themesnapbranding">基本資料</a>章節中的新類別新增 CSS 選取器。';
$string['pbb_enable'] = '啟用以資訊為基礎的品牌塑造';
$string['pbb_enable_description'] = '僅將類別新增至 body 標籤 (如果使用)。';
$string['pbb_field'] = '要使用的使用者欄位';
$string['pbb_field_description'] = '系統會將此欄位值轉換為 slug 格式，並在前面加上 <code>snap-pbb-</code> 作為 CSS 類別名稱。';
$string['cachedef_profile_based_branding'] = '以資訊為基礎的品牌塑造的快取。';
$string['cachedef_course_card_bg_image'] = '課程背景影像的快取。';
$string['cachedef_course_card_teacher_avatar'] = '教師頭像的快取。';
$string['cachedef_course_card_teacher_avatar_index'] = '教師頭像索引的快取。';
$string['accessforumstringdis'] = '顯示選項';
$string['accessforumstringmov'] = '移動選項';
$string['accesscalendarstring'] = '行事曆';
$string['accessglobalsearchstring'] = '搜尋';
$string['admineventwarning'] = '若要查看所有課程中的事件，';
$string['gotocalendarsnap'] = '請前往網站行事曆。';
$string['quizattemptswarn'] = '排除已暫停使用者的嘗試';
$string['quizfeedback'] = '意見回應';
$string['validratio'] = '此顏色組合不符合 WCAG 2.0 最小比率值 4.5:1';
$string['invalidratio'] = '此顏色組合不符合
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 最小比率值 4.5:1</a>。值："{$a}"';
$string['imageinvalidratio'] = '由於不符合 WCAG 2.0 最小比率值 4.5:1，此影像可能有對比度問題。平均像素值：「{$a}」';
$string['catinvalidratio'] = '下列顏色類別不符合
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 最小比率值 4.5:1</a>：
網站背景顏色 (白色)：「{$a->white}」。瀏覽列背景顏色：「{$a->custombar}」。「我的課程」按鈕背景顏色：「{$a->customnav}」';
$string['imageinvalidratiocategory'] = '由於不符合 WCAG 2.0 最小比率值 4.5:1，此影像的主題顏色可能有對比度問題。平均像素值：「{$a}」';
$string['lazyload_mod_page'] = '啟用頁面資源的預設延遲載入';
$string['lazyload_mod_page_description'] = '若啟用，此設定可幫助有許多頁面的課程大幅縮短頁面載入時間。';
$string['pmadvancedfeed_viewmore'] = '觀看更多';
$string['pmadvancedfeed_reload'] = '重新整理';
$string['multimediacard'] = '多媒體檔案不會在 Snap 主題的活動卡檢視中顯示。此設定只會套用至小型活動和資源卡的首頁和課程頁面。';
$string['enabledlogin'] = '顯示的登入選項';
$string['enabledlogindesc'] = '選取要顯示的登入選項。';
$string['moodlelogin'] = '僅顯示 Moodle 登入';
$string['alternativelogin'] = '僅顯示替代登入選項';
$string['bothlogin'] = '顯示兩種登入選項';
$string['enabledloginorder'] = '登入選項順序';
$string['enabledloginorderdesc'] = '選取要先顯示哪一種登入選項。';
$string['moodleloginfirst'] = '先顯示 Moodle 登入';
$string['alternativeloginfirst'] = '先顯示替代登入選項';
$string['alternativeloginoptions'] = '替代登入選項';
$string['openmessagedrawer'] = '開啟隱藏式傳訊選單。';
$string['design_mod_page'] = '針對頁面資源啟用先前的設計';
$string['design_mod_page_description'] = '若啟用，頁面資源內容將會在相同頁面、課程或首頁內顯示。';
$string['refreshdeadlinestask'] = '重新整理截止時間快取資料。這應該在所有使用者登入前執行。';
$string['resetdeadlinesquerycounttask'] = '重設期限查詢次數';
$string['refreshdeadlinestaskoff'] = '沒有尋找要填入的資料。請在 Snap 的個人功能表設定中開啟設定「使用排定任務重新整理截止日期」，以允許此任務填入截止日期快取資料。';
$string['activityrestriction'] = '活動限制';
$string['hideandshowactioncb'] = '隱藏和顯示活動核取方塊動作';
$string['retryfeed'] = '這項摘要目前無法使用，請稍後再試。摘要：{$a}';
$string['loadingfeed'] = '載入中，可能會需要一些時間';
$string['hvpcustomcss'] = 'H5P 自訂 CSS';
$string['hvpcustomcssdesc'] = '自訂 H5P 模組的 CSS (moodle.org/plugins/mod_hvp)，若已安裝該模組。';
$string['courselimitstrdanger'] = '不會顯示已達課程限制的進度列。';
$string['courselimitstrwarning'] = '如果已列出超過 {$a} 個課程，則不會顯示進度列';
$string['tilesformatcoursehomealttext'] = '課程首頁';
$string['editmodetiles'] = '編輯內容';
$string['totop'] = '移至頂端';
$string['loginsetting'] = '登入頁面';
$string['loginbgimgheading'] = '登入頁面範本';
$string['loginbgimgheadingdesc'] = 'Snap 允許在不同範本之間切換，選擇要顯示在登入頁面者。請在下列下拉式清單中的不同選項之間選取。';
$string['loginpagetemplate'] = '選取要使用的登入頁面範本';
$string['classic_template'] = '經典範本';
$string['loginbgimg'] = '登入背景影像';
$string['loginbgimgdesc'] = '選取將出現在登入頁面背景的影像。若要提升所顯示影像的體驗，請上傳長寬比為 16:9 的檔案 (解析度 720p 或畫質為 1280x720 像素)。上傳的影像必須具備相同尺寸，才能有正確的視覺效果。';
$string['stylish_template'] = '風格範本';
