<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  Copyright (c) 2023 Open LMS (https://www.openlms.net)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = 'Sobre este curso';
$string['activity'] = 'Atividade';
$string['action:changeassetvisibility'] = 'alterar visibilidade do ativo';
$string['action:duplicateasset'] = 'duplicar ativo';
$string['action:changesectionvisibility'] = 'alterar visibilidade da seção';
$string['action:highlightsectionvisibility'] = 'destacar visibilidade da seção';
$string['action:sectiontoc'] = 'obter índice da seção';
$string['addanewsection'] = 'Criar uma nova seção';
$string['addresourceoractivity'] = 'Criar atividade de aprendizagem';
$string['admin'] = 'Administrador';
$string['advancedbrandingheading'] = 'Branding avançado';
$string['ago'] = 'atrás';
$string['answered'] = 'Respondido';
$string['appendices'] = 'Ferramentas';
$string['arialabelnewsarticle'] = 'artigo de notícias';
$string['assigndraft'] = 'O rascunho requer sua confirmação';
$string['assignreopened'] = 'Reaberto';
$string['at'] = 'em';
$string['attempted'] = 'Tentativa realizada';
$string['basics'] = 'Básico';
$string['brandingheading'] = 'Branding';
$string['browse'] = 'Procurar';
$string['browseallcourses'] = 'Procurar todos os cursos';
$string['cachedef_activity_deadlines'] = 'Armazenar em cache para prazos de atividades dos usuários.';
$string['cachedef_generalstaticappcache'] = 'Dividir cache de nível de aplicativo estático geral';
$string['cachedef_course_completion_progress'] = 'Isso é usado para armazenar em cache os dados de conclusão por curso/usuário.';
$string['cachedef_course_completion_progress_ts'] = 'Isso é usado para que possamos invalidar caches de nível de sessão se as configurações de conclusão do curso para um curso ou módulo forem alteradas.';
$string['cachedef_webservicedefinitions'] = 'Armazenamento em cache para definições de serviços da web geradas automaticamente.';
$string['card'] = 'Cartão';
$string['categoryedit'] = 'Editar categoria';
$string['category_color'] = 'Cor da categoria';
$string['category_color_description'] = 'Cor da categoria do curso. Os cursos infantis obtêm a configuração de categoria do responsável mais próximo';
$string['category_color_palette'] = 'Paleta de cores';
$string['category_color_palette_description'] = 'Consulte o valor hexadecimal correspondente para a cor fornecida. Isso não
afetará qualquer configuração. É apenas uma amostra para ajudar os usuários a criar o valor da configuração.';
$string['changecoverimage'] = 'Alterar imagem de capa';
$string['changefullname'] = 'Alterar nome do site';
$string['chapters'] = 'Capítulos';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></div>';
$string['close'] = 'Fechar';
$string['conditional'] = 'Condicional';
$string['contents'] = 'Conteúdo';
$string['contributed'] = 'Contribuído';
$string['courses'] = 'Cursos';
$string['coursecontacts'] = 'Contatos do curso';
$string['coursedisplay'] = 'Exibição do curso';
$string['coursefootertoggle'] = 'Rodapé do curso';
$string['coursefootertoggledesc'] = 'O rodapé do curso mostra informações úteis para os usuários em uma página do curso, incluindo os contatos, a descrição e a atividade recente do curso.';
$string['courseformatnotification'] = 'O formato de curso que você está usando atualmente não é totalmente compatível com o tema Snap. Para melhor experiência, o Open LMS recomenda usar os formatos de curso Tópicos ou Semanal com o tema Snap. O formato do curso pode ser alterado nas <a href="{$a}">configurações do curso</a>.';
$string['coursefixydefaulttext'] = 'Você não está inscrito em nenhum curso no momento.<br>Os cursos nos quais você está inscrito serão exibidos aqui.';
$string['coursegrade'] = 'Nota do curso:';
$string['coursepartialrender'] = 'Habilitar o carregamento lento para seções do curso';
$string['coursepartialrenderdesc'] = 'Se esta opção estiver habilitada, as seções do curso serão carregadas sob demanda quando selecionadas por um usuário. Isso ajuda cursos com grandes quantidades de conteúdo a carregar mais rapidamente.';
$string['coursenavigation'] = 'Navegação do curso';
$string['coursesummaryfilesunsuitable'] = 'Esvazie seus arquivos de resumo do curso antes de tentar alterar a imagem da capa';
$string['courseactivitieslabel'] = 'Atividades da seção';
$string['coursetools'] = 'Painel do curso';
$string['coverdisplay'] = 'Exibição da capa';
$string['covercarousel'] = 'Carrossel da capa';
$string['covercarouselon'] = 'Usar o carrossel da capa';
$string['covercarouseldescription'] = '<p>O carrossel é um conjunto de faixas giratórias, ou uma apresentação de slides, que é exibida na página inicial do site em vez da imagem da capa.</p>
<p>Adicione até 3 imagens, um título para cada slide e um subtítulo opcional. As imagens de 1.200 x 600 pixels funcionam melhor.</p>';
$string['covercarouselsronly'] = 'Este é um carrossel com slides de rotação automática. Ative qualquer um dos botões para desativar a rotação. Use os botões Próximo e Anterior para navegar ou ir para um slide usando os pontos de slide.';
$string['covercarouselplaybutton'] = 'Retome os slides de rotação automática para o carrossel.';
$string['covercarouselpausebutton'] = 'Pause os slides de rotação automática para o carrossel.';
$string['coverimage'] = 'Imagem de capa';
$string['covervideo'] = 'Vídeo da capa';
$string['comingsoon'] = 'Em breve!';
$string['createsection'] = 'Criar seção';
$string['current'] = 'Atual';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Saiba que com grandes poderes vêm grandes responsabilidades. Você é responsável pela solução de qualquer problema causado pelo CSS adicionado aqui. O Suporte do Open LMS não soluciona nem oferece nenhuma ajuda para o conteúdo relacionado ao CSS.';
$string['customtopbar'] = 'Barra de navegação';
$string['customisenavbar'] = 'Alterar as cores da barra de navegação';
$string['customisenavbutton'] = 'Alterar as cores do botão Meus Cursos';
$string['customisecustommenu'] = 'Mudar cor do texto do menu personalizado';
$string['custommenutext'] = 'Cor do texto do menu personalizado';
$string['deadlines'] = 'Prazos';
$string['deadlinestoggle'] = 'Prazos';
$string['deadlinestoggledesc'] = 'Mostra aos usuários os prazos de atividades futuras dos cursos nos quais eles estão inscritos.';
$string['defaultsummary'] = 'Use esta área para descrever o que este tópico aborda, utilizando texto, imagens, áudio e vídeo.';
$string['defaultintrosummary'] = 'Bem-vindo ao seu novo curso {$a}.
<br>Para começar, descreva o que o seu curso aborda, utilizando texto, imagens, áudio e vídeo.';
$string['defaulttopictitle'] = 'Tópico sem título';
$string['debugerrors'] = 'Depurar erros';
$string['deleteassetconfirm'] = 'Excluir {$a}';
$string['deletingasset'] = 'Excluindo {$a}';
$string['deletingassetname'] = 'Excluindo {$a->type} &quot;{$a->name}&quot;';
$string['deletesectionconfirm'] = 'Excluir seção';
$string['deletingsection'] = 'Excluindo a seção &quot;{$a}&quot;';
$string['draft'] = 'Não publicado para alunos';
$string['dropzonelabel'] = 'Solte os arquivos para anexar ou <span class="fake-link">navegue</span>';
$string['due'] = 'Prazo {$a}';
$string['edit'] = 'Editar &quot;{$a}&quot;';
$string['editcoursecontent'] = 'Editar blocos';
$string['editcoursesettings'] = 'Configurações do curso';
$string['editcoursetopic'] = 'Editar seção';
$string['editcustomfooter'] = 'Editar rodapé';
$string['editcustommenu'] = 'Editar menu personalizado';
$string['error'] = 'Erro';
$string['errorgettingfeed'] = 'Ocorreu um erro ao obter os itens do feed.';
$string['error:categorycolorinvalidjson'] = 'Formato JSON incorreto para categorias de cursos';
$string['error:categorycolorinvalidvalue'] = 'O código de registro ou o valor da cor para a categoria &quot;{$a}&quot; não são válidos';
$string['error:categorynotfound'] = 'O registro de categoria com código &quot;{$a}&quot; não foi encontrado';
$string['error:coverimageexceedsmaxbytes'] = 'A imagem de capa ultrapassa o tamanho máximo de arquivo permitido ao nível do site ({$a})';
$string['error:coverimageresolutionlow'] = 'Para obter a melhor qualidade, recomendamos uma imagem de, pelo menos, 1024 px de largura.';
$string['error:duplicatedcategoryids'] = 'Formato JSON incorreto, algumas identificações são duplicadas';
$string['error:failedtochangeassetvisibility'] = 'Falha ao ocultar/mostrar ativo';
$string['error:failedtochangesectionvisibility'] = 'Falha ao ocultar/mostrar seção';
$string['error:failedtohighlightsection'] = 'Falha ao destacar seção';
$string['error:failedtoduplicateasset'] = 'Falha ao duplicar';
$string['error:failedtodeleteasset'] = 'Falha ao excluir ativo';
$string['error:failedtotoc'] = 'Ocorreu uma falha na obtenção de TOC.';
$string['extension'] = 'Extensão {$a}';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'O URL de sua página do Facebook.';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Os favicons aparecem na barra de endereço do seu navegador da web, nos favoritos de um usuário e nos atalhos móveis.';
$string['favorite'] = 'Favorito {$a}';
$string['favorited'] = 'Marcado como favorito {$a}';
$string['featurespots'] = 'Locais dos recursos';
$string['featurespotsedit'] = 'Editar locais dos recursos';
$string['featurespotshelp'] = '<p>Adicione até 3 pontos de recursos à página inicial do seu site para destacar os principais benefícios para os usuários atuais e potenciais.</p>
<p>Adicione um título, conteúdo e uma imagem opcional para cada recurso. As imagens devem ser quadradas e não podem ser maiores que 200px por 200px.</p>';
$string['featurespotsheading'] = 'Título dos locais de recursos';
$string['featureonetitle'] = 'Título do recurso 1';
$string['featuretwotitle'] = 'Título do recurso 2';
$string['featurethreetitle'] = 'Título do recurso 3';
$string['featureonetitlelink'] = 'Link do título do recurso 1';
$string['featuretwotitlelink'] = 'Link do título do recurso 2';
$string['featurethreetitlelink'] = 'Link do título do recurso 3';
$string['featuretitlelinkdesc'] = 'Digite o URL ao qual você deseja vincular esse ponto do recurso. É possível adicionar links externos ou internos no seu site. Para adicionar um link interno, copie-o do URL do site depois de /. Por exemplo, para ter um link para um curso, ele seria “course/view.php?id=160”. Para adicionar um link externo, inicie o link com https://';
$string['featureonetitlecb'] = 'Recurso 1 aberto em uma nova janela';
$string['featuretwotitlecb'] = 'Recurso 2 aberto em uma nova janela';
$string['featurethreetitlecb'] = 'Recurso 3 aberto em uma nova janela';
$string['featuretitlecbdesc'] = 'Se habilitado, o link adicionado ao ponto apresentado será aberto em uma nova janela';
$string['featureonetext'] = 'Conteúdo do recurso 1';
$string['featuretwotext'] = 'Conteúdo do recurso 2';
$string['featurethreetext'] = 'Conteúdo do recurso 3';
$string['featureoneimage'] = 'Imagem do recurso 1';
$string['featuretwoimage'] = 'Imagem do recurso 2';
$string['featurethreeimage'] = 'Imagem do recurso 3';
$string['featuredcourses'] = 'Cursos apresentados';
$string['featuredcourseshelp'] = 'Destaque até 8 cursos apresentados para a página inicial do seu site. Digite o ID do curso para apresentar um curso.';
$string['featuredcoursesheading'] = 'Títulos de cursos apresentados';
$string['featuredcourseone'] = 'Curso 1 apresentado';
$string['featuredcoursetwo'] = 'Curso 2 apresentado';
$string['featuredcoursethree'] = 'Curso 3 apresentado';
$string['featuredcoursefour'] = 'Curso 4 apresentado';
$string['featuredcoursefive'] = 'Curso 5 apresentado';
$string['featuredcoursesix'] = 'Curso 6 apresentado';
$string['featuredcourseseven'] = 'Curso 7 apresentado';
$string['featuredcourseeight'] = 'Curso 8 apresentado';
$string['featuredcoursesedit'] = 'Editar cursos apresentados';
$string['featuredcoursesbrowseall'] = 'Procurar todos os cursos';
$string['featuredcoursesbrowsealldesc'] = 'Adicionar um link Procurar todos os cursos';
$string['feedbackavailable'] = 'Comentários disponíveis';
$string['feedbacktoggle'] = 'Comentários e avaliação';
$string['feedbacktoggledesc'] = 'Mostrar aos alunos seus comentários mais recentes e mostrar aos educadores os envios mais recentes que precisam de avaliação.';
$string['footnote'] = 'Rodapé do site';
$string['footnotedesc'] = 'O rodapé é exibido em todo o site. Esse é o melhor lugar para colocar links para ajuda, suporte e quaisquer outros sites que sua organização tenha que você queira compartilhar com alunos e educadores. Por exemplo, a biblioteca ou um endereço de e-mail.';
$string['forcepwdwarningpersonalmenu'] = 'Você deve <a href="{$a}">alterar sua senha</a> antes de usar o menu pessoal.';
$string['forumauthor'] = 'Autor';
$string['forumlastpost'] = 'Última publicação';
$string['forumpicturegroup'] = 'Grupo';
$string['forumreplies'] = 'Respostas';
$string['forumtopic'] = 'Tópico';
$string['forumposts'] = 'Mensagens do fórum';
$string['forumpoststoggle'] = 'Mensagens do fórum';
$string['forumpoststoggledesc'] = 'Mostrar aos usuários as 10 postagens de fórum mais recentes de seus cursos';
$string['fullname'] = 'Nome do site';
$string['fullnamedesc'] = 'O nome do seu site.';
$string['graderadviseuserreport'] = 'O &quot;relatório de avaliação&quot; não funciona bem em dispositivos móveis. Recomendamos o uso do &quot;relatório do usuário&quot; em vez disso.';
$string['grading'] = 'Avaliação';
$string['help'] = 'Ajuda';
$string['helpguide'] = 'Guia de ajuda';
$string['headingfont'] = 'Fonte do título';
$string['headingfont_desc'] = 'Esta fonte (sans-serif) é usada nos cabeçalhos (elementos h1 - h6) em todo o seu site. Se você estiver incluindo uma fonte da Web personalizada, lembre-se de adicioná-la ao formulário HTML extra do Moodle. Se deseja modificar as fontes de outros elementos, use a opção CSS Personalizado. Para obter exemplos sobre como fazer isso, consulte esta <a href="https://help.openlms.net/en/administrator/manage-a-site/snap-font-family-with-custom-css/" target="_blank">documentação</a>.';
$string['helpwithlogin'] = 'Ajuda com o logon';
$string['helpwithloginandguest'] = 'Ajuda com o logon/acesso de convidados';
$string['hiddencoursestoggle'] = 'Cursos ocultos';
$string['highlightedsection'] = 'destacado';
$string['home'] = 'página inicial';
$string['image'] = 'imagem';
$string['images'] = 'Imagens';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'O URL da sua conta do Instagram.';
$string['introduction'] = 'Introdução';
$string['jsontext'] = 'Texto JSON';
$string['jsontextdescription'] = 'A área de texto valida o JSON fornecido, de modo que apenas as categorias existentes são permitidas,
somente valores numéricos como registros de id (registros de categoria) são válidos e somente valores hexadecimais são aceitos como cores.
Veja este exemplo:<br>
{&quot;1&quot;:&quot;#FAAFFF&quot;,<br>
&quot;45&quot;:&quot;#AFF&quot;,<br>
&quot;65&quot;:&quot;#FFF228&quot;,<br>
&quot;12&quot;:&quot;#CC0084&quot;,<br>
&quot;56&quot;:&quot;#CC0087&quot;,<br>
&quot;89&quot;:&quot;#CCF084&quot;}';
$string['knowledgebase'] = 'Base de conhecimento do Open LMS';
$string['list'] = 'Lista';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'O URL do LinkedIn da sua organização.';
$string['leftnav'] = 'Sumário';
$string['leftnavdesc'] = 'Selecione onde exibir o sumário. A lista oferece mais espaço ao conteúdo e funciona bem para cursos com muitos tópicos.';
$string['loading'] = 'Carregando…';
$string['loggedinasguest'] = 'Você fez logon como convidado';
$string['loggedoutmsg'] = 'Você está atualmente desconectado. Se desejar continuar usando este site, faça login novamente.';
$string['loggedoutmsgtitle'] = 'Você está desconectado';
$string['loggedoutfailmsg'] = 'Você precisa ter feito login em {$a}.';
$string['loginform'] = 'Login';
$string['logo'] = 'Logotipo';
$string['logodesc'] = 'Seu logotipo é exibido no cabeçalho em todo o site.';
$string['menu'] = 'Meus cursos';
$string['messageread'] = 'Mensagem lida';
$string['messages'] = 'Mensagens';
$string['messagestoggle'] = 'Mensagens';
$string['messagestoggledesc'] = 'Mostrar aos usuários suas mensagens mais recentes recebidas nas últimas 12 semanas.';
$string['more'] = 'Mais';
$string['morenews'] = 'Mais notícias';
$string['movingstartedhelp'] = 'Navegue até o local em que você deseja posicionar a seção &quot;{$a}&quot;';
$string['movingdropsectionhelp'] = 'Posicione a seção &quot;{$a->moving}&quot; antes da seção &quot;{$a->before}&quot;';
$string['moving'] = 'Movendo &quot;{$a}&quot;';
$string['movingcount'] = 'Movendo {$a} objetos';
$string['movefailed'] = 'Falha ao mover &quot;{$a}&quot;';
$string['move'] = 'Mover &quot;{$a}&quot;';
$string['movehere'] = 'Mover para cá';
$string['movesection'] = 'Mover seção';
$string['navbarbg'] = 'Cor do fundo';
$string['navbarlink'] = 'Cor do texto';
$string['navbarbuttoncolor'] = 'Cor do fundo';
$string['navbarbuttonlink'] = 'Cor do texto';
$string['nextsection'] = 'Próxima seção';
$string['nodeadlines'] = 'Você não tem prazos iminentes.';
$string['noforumposts'] = 'Você não tem postagens de fórum relevantes.';
$string['nograded'] = 'Você não tem comentários recentes.';
$string['nograding'] = 'Você não tem envios a serem avaliados.';
$string['nomessages'] = 'Você não tem mensagens.';
$string['notanswered'] = 'Não respondido';
$string['notattempted'] = 'Nenhuma tentativa';
$string['notcontributed'] = 'Não contribuído';
$string['notpublished'] = 'Não publicado para alunos';
$string['notsubmitted'] = 'Não enviado';
$string['overdue'] = 'Vencidas';
$string['personalmenu'] = 'Menu pessoal';
$string['personalmenufeatures'] = 'Recursos do menu pessoal';
$string['personalmenulogintoggle'] = 'Mostrar menu pessoal ao fazer login';
$string['personalmenulogintoggledesc'] = 'Abre o menu pessoal imediatamente após o login';
$string['personalmenuadvancedfeedsenable'] = 'Habilitar feeds avançados';
$string['personalmenuadvancedfeedsenabledesc'] = 'Os feeds avançados carregam alguns itens de menus pessoais, o que permite tempos de carregamento mais rápidos e atualiza o conteúdo sob demanda.';
$string['personalmenuadvancedfeedsperpage'] = 'Contagem de exibição de itens de feeds avançados';
$string['personalmenuadvancedfeedsperpagedesc'] = 'Escolha o número de itens a serem exibidos no feed. Os usuários podem selecionar <strong>Visualizar mais</strong> para exibir itens adicionais.';
$string['personalmenuadvancedfeedslifetime'] = 'Duração avançada dos feeds';
$string['personalmenuadvancedfeedslifetimedesc'] = 'Escolha a duração em que os feeds permanecerão em cache no navegador após fazer login. Configurar o valor como 0 não salvará os feeds em cache no navegador.';
$string['personalmenurefreshdeadlines'] = 'Atualizar prazos de entrega usando a tarefa agendada.';
$string['personalmenurefreshdeadlinesdesc'] = 'Quando a tarefa for realizada, os dados de prazo de entrega serão atualizados para tempos de carregamento de página mais rápidos.';
$string['pld'] = 'PLD';
$string['pluginname'] = 'Snap';
$string['poster'] = 'Imagem de capa';
$string['posterdesc'] = 'Uma imagem de cabeçalho grande para a página inicial do seu site. Imagens de paisagem (1200 x 600 pixels) ou maiores funcionam melhor.';
$string['poweredbyrunby'] = 'Criado com <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a>,
um produto baseado no <a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a>.<br>
Copyright © {$a->year} Open LMS, Todos os direitos reservados.';
$string['previoussection'] = 'Seção anterior';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'O código do curso marcado como favorito pelo usuário';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'O código do usuário que marcou o curso como favorito';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'O carimbo de tempo de quando o usuário marcou o curso como favorito';
$string['privacy:metadata:theme_snap_course_favorites'] = 'Armazena os favoritos do curso do usuário para o Snap';
$string['problemsfound'] = 'Problemas encontrados';
$string['progress'] = 'Progresso';
$string['readmore'] = 'Leia mais »';
$string['recentactivity'] = 'Atividade recente';
$string['recentfeedback'] = 'Comentários';
$string['region-main'] = 'Principal';
$string['region-side-main-box'] = 'Principal';
$string['region-side-post'] = 'Direita';
$string['region-side-pre'] = 'Esquerda';
$string['region-side-top'] = 'Em cima';
$string['released'] = 'Disponibilizado: {$a}';
$string['reopened'] = 'Reaberto';
$string['resourcedisplay'] = 'Exibição do recurso';
$string['resourcedisplayhelp'] = 'Selecione como os anexos e os links aparecem no seu curso. O tema Snap não é compatível com arquivos multimídia na descrição de cartões de atividades e recursos pequenos.';
$string['displaydescription'] = 'Mostrar descrição';
$string['displaydescriptionhelp'] = 'Selecione para mostrar uma descrição do recurso e atividades de URL em uma nova página primeiro. Os alunos acessarão conteúdo da descrição.';
$string['search'] = 'Pesquisar conteúdo';
$string['showcoursegradepersonalmenu'] = 'Notas';
$string['showcoursegradepersonalmenudesc'] = 'Mostrar aos usuários suas notas nos cartões do curso no menu pessoal';
$string['socialmedia'] = 'Mídia social';
$string['submitted'] = 'Enviada';
$string['sitedescription'] = 'Descrição do site';
$string['subtitle'] = 'Subtítulo';
$string['subtitle_desc'] = 'Descreve resumidamente seu site para os usuários.';
$string['summarylabel'] = 'Resumo da seção';
$string['themecolor'] = 'Cor do site';
$string['themecolordesc'] = 'Cores brilhantes funcionam melhor e darão ao seu site um visual moderno.';
$string['title'] = 'Título';
$string['top'] = 'Em cima';
$string['topbarbgcolor'] = 'Cor da barra de navegação';
$string['topbarlinkcolor'] = 'Cor do ícone e do link da barra de navegação';
$string['topbarbuttoncolor'] = 'Plano de fundo de Meus cursos';
$string['togglenavigation'] = 'Alternar navegação';
$string['topicactions'] = 'Ações no tópico';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'O URL de sua conta do Twitter.';
$string['unenrolme'] = 'Cancelar minha inscrição';
$string['enrolme'] = 'Inscreva-me';
$string['unread'] = 'não lida';
$string['unsupportedcoverimagetype'] = 'Tipo de imagem de capa incompatível  ({$a})';
$string['via'] = 'via';
$string['viewcourse'] = 'Visualizar curso';
$string['viewmore'] = 'Ver mais';
$string['viewyourprofile'] = 'Visualizar seu perfil';
$string['viewmyfeedback'] = 'Ver meus comentários';
$string['viewcalendar'] = 'Visualizar meu calendário';
$string['viewforumposts'] = 'Visualizar meus posts no fórum';
$string['viewmessaging'] = 'Visualizar minhas mensagens';
$string['vieworiginalimage'] = 'Visualizar imagem original';
$string['visibility'] = 'Visibilidade';
$string['xofyanswered'] = '{$a->completed} de {$a->participants} responderam';
$string['xofyattempted'] = '{$a->completed} de {$a->participants} realizaram tentativas';
$string['xofycontributed'] = '{$a->completed} de {$a->participants} contribuíram';
$string['xofysubmitted'] = '{$a->completed} de {$a->participants} enviaram';
$string['xungraded'] = '{$a} não avaliados';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'O URL do seu canal do YouTube.';
$string['showallsectionsdisabled'] = 'Devido à sua linguagem de design, &quot;Mostrar todas as seções em uma página&quot; não está disponível em Snap.';
$string['disabled'] = 'Desativado';
$string['showappearancedisabled'] = 'A linguagem de desenvolvimento do Snap impede alterações às configurações de &quot;Aparência&quot;';
$string['pbb'] = 'Marca baseada no perfil';
$string['pbb_description'] = 'Ao ativar a <strong>Marca baseada no perfil</strong>, você poderá personalizar a experiência da marca para um grupo específico de usuários com base no campo de perfil de usuário escolhido.
<ul><li>O valor do campo do usuário será <em>especificado</em>; convertendo todos os caracteres em minúsculas e separando-os com um traço (-)</li>
<li>A string <code>snap-pbb-</code> será pré-suspensa</li>
<li>Esta classe será adicionada à tag <code>body</code> do HTML</li></ul>
Por exemplo, o valor do campo do usuário <em>Blueberry Extravaganza</em> será indicado para ser <code>snap-pbb-blueberry-extravaganza</code><br /><br />
Esse recurso é usado em conjunto com o CSS personalizado, você precisará adicionar seletores CSS usando as novas classes na seção <a class="snap-settings-tab-link" href="#themesnapbranding">Noções básicas</a>.';
$string['pbb_enable'] = 'Ativar marca baseada no perfil';
$string['pbb_enable_description'] = 'Adiciona a classe à tag body apenas se estiver ativo.';
$string['pbb_field'] = 'Campo do usuário a ser usado';
$string['pbb_field_description'] = 'Este valor do campo será reduzido e usado como um nome de classe CSS iniciado por <code>snap-pbb-</code>.';
$string['cachedef_profile_based_branding'] = 'Armazenamento em cache para marca baseada no perfil.';
$string['cachedef_course_card_bg_image'] = 'Armazenamento em cache para imagem de plano de fundo do curso.';
$string['cachedef_course_card_teacher_avatar'] = 'Armazenamento em cache para avatares do professor.';
$string['cachedef_course_card_teacher_avatar_index'] = 'Armazenamento em cache para índice de avatares do professor.';
$string['accessforumstringdis'] = 'Opções';
$string['accessforumstringmov'] = 'Mover opções';
$string['accesscalendarstring'] = 'Calendário';
$string['accessglobalsearchstring'] = 'Busca';
$string['admineventwarning'] = 'Para ver eventos de todos os cursos,';
$string['gotocalendarsnap'] = 'vá para o calendário do site.';
$string['quizattemptswarn'] = 'Exclui tentativas de usuários suspensos';
$string['quizfeedback'] = 'Comentários';
$string['validratio'] = 'Essa combinação de cores está em conformidade com o valor de proporção mínima do WCAG 2.0 4.5:1';
$string['invalidratio'] = 'Essa combinação de cores não está em conformidade com o
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">Valor mínimo da razão WCAG 2.0 4.5:1</a>. Valor: &quot;{$a}&quot;';
$string['imageinvalidratio'] = 'Essa imagem pode ter problemas de contraste por causa da não conformidade com o valor de proporção mínima do WCAG 2.0 4.5:1. Valor médio de pixel: &quot;{$a}&quot;';
$string['catinvalidratio'] = 'As seguintes categorias de cores não estão em conformidade com o
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">Valor mínimo da razão WCAG 2.0 4.5:1</a>:
Em relação à cor de fundo do local (branco): &quot;{$a->white}&quot;. Na cor de fundo da barra de navegação: &quot;{$a->custombar}&quot;. Em relação à cor de fundo do botão Meus cursos: &quot;{$a->customnav}&quot;';
$string['imageinvalidratiocategory'] = 'Essa imagem pode ter problemas de contraste com a cor do tema por causa da não conformidade com o valor de proporção mínima do WCAG 2.0 4.5:1. Valor médio de pixel: &quot;{$a}&quot;';
$string['lazyload_mod_page'] = 'Habilitar carregamento lento padrão para recursos da página';
$string['lazyload_mod_page_description'] = 'Se esta opção estiver habilitada, esta configuração diminuirá significativamente os tempos de carregamento de páginas dos cursos que tiverem muitas páginas.';
$string['pmadvancedfeed_viewmore'] = 'Ver mais';
$string['pmadvancedfeed_reload'] = 'Atualizar';
$string['multimediacard'] = 'Os arquivos multimídia não serão exibidos nas visualizações dos cartões de atividades com o tema Snap. Isso será aplicado na página inicial e nas páginas do curso apenas para os cartões de atividades e recursos pequenos.';
$string['enabledlogin'] = 'Opções de login exibidas';
$string['enabledlogindesc'] = 'Selecione as opções de login que devem ser exibidas.';
$string['moodlelogin'] = 'Exibir apenas o login do Moodle';
$string['alternativelogin'] = 'Exibir apenas opções de login alternativo';
$string['bothlogin'] = 'Exibir ambas as opções de login';
$string['enabledloginorder'] = 'Ordem das opções de login';
$string['enabledloginorderdesc'] = 'Selecione qual opção de login deve ser exibida primeiro.';
$string['moodleloginfirst'] = 'Exibir login do Moodle primeiro';
$string['alternativeloginfirst'] = 'Exibir opções de login alternativo primeiro';
$string['alternativeloginoptions'] = 'Opções de login alternativo';
$string['openmessagedrawer'] = 'Abrir a caixa de mensagens.';
$string['design_mod_page'] = 'Ativar o design anterior para os recursos de página';
$string['design_mod_page_description'] = 'Se ativado, o conteúdo do recurso da página será exibido dentro da mesma página, curso ou página inicial.';
$string['refreshdeadlinestask'] = 'Atualizar dados em cache de prazos de entrega. Deve ser executado antes do login de todos os usuários.';
$string['resetdeadlinesquerycounttask'] = 'Redefinir contagem de consultas de prazos';
$string['refreshdeadlinestaskoff'] = 'Não procurou dados para preencher. Ative a configuração &quot;Atualizar prazos usando a tarefa programada&quot; nas configurações do menu Pessoal do Snap para permitir que essa tarefa preencha os dados de prazos armazenados em cache.';
$string['activityrestriction'] = 'Restrição de atividade';
$string['hideandshowactioncb'] = 'Ocultar e mostrar ação da caixa de seleção de atividade';
$string['retryfeed'] = 'Este feed está indisponível no momento. Verifique novamente mais tarde. Feed: {$a}';
$string['loadingfeed'] = 'Carregando...pode levar tempo';
$string['hvpcustomcss'] = 'CSS Personalizado do H5P';
$string['hvpcustomcssdesc'] = 'CSS Personalizado para o módulo do H5P (moodle.org/plugins/mod_hvp), se instalado.';
$string['courselimitstrdanger'] = 'A barra de progresso do limite do curso atingido não será exibida.';
$string['courselimitstrwarning'] = 'Se mais de {$a} forem listados, a barra de progresso não será exibida';
$string['tilesformatcoursehomealttext'] = 'Página inicial do curso';
$string['editmodetiles'] = 'Editar conteúdo';
$string['totop'] = 'Ir ao início';
$string['loginsetting'] = 'Página de login';
$string['loginbgimgheading'] = 'Modelo da página de login';
$string['loginbgimgheadingdesc'] = 'Snap permite alterar entre diferentes modelos a serem exibidos na página de login. Selecione entre diferentes opções no menu suspenso abaixo.';
$string['loginpagetemplate'] = 'Selecione o modelo de página de login a ser usado';
$string['classic_template'] = 'Modelo clássico';
$string['loginbgimg'] = 'Imagem de fundo de login';
$string['loginbgimgdesc'] = 'Selecione as imagens que serão exibidas no plano de fundo da página de login. Para ter uma melhor experiência com as imagens exibidas, carregue arquivos com uma proporção de 16:9 (resolução de 720p ou dimensões de 1.280 x 720 pixels). As imagens carregadas precisam ter as mesmas dimensões para uma visualização correta.';
$string['stylish_template'] = 'Modelo estiloso';
