/**
 * This file is part of Moodle - http://moodle.org/
 *
 * Moodle is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Moodle is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package
 * @copyright Copyright (c) 2015 Open LMS (https://www.openlms.net)
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("theme_snap/cover_image",["jquery","core/log","core/ajax","core/notification","theme_snap/ajax_notification"],(function($,log,ajax,notification,ajaxNotify){var addCoverImageAlert=function(id,msg){let position=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;if("dialogue"===position)var alertPosition=".snap_cover_image_description";else alertPosition="#snap-coverimagecontrol";var closestr=M.util.get_string("closebuttontitle","moodle");$(id).length||$(alertPosition).before('<div id="'+id+'" class="snap-alert-cover-image alert alert-warning" role="alert">'+msg+'<button type="button" class="close" data-dismiss="alert" aria-label="'+closestr+'"><span aria-hidden="true">&times;</span></button></div>')},state1=function(){$("#snap-changecoverimageconfirmation .ok").removeClass("ajaxing"),$("#snap-alert-cover-image-size").remove(),$("#snap-alert-cover-image-bytes").remove(),$('label[for="snap-coverfiles"]').removeClass("ajaxing"),$("#snap-changecoverimageconfirmation").removeClass("state-visible"),$('label[for="snap-coverfiles"]').addClass("state-visible"),$("#snap-coverfiles").val(""),$("body").removeClass("cover-image-change")},state2=function(){$("#snap-alert-cover-image-upload-failed").remove(),$("#snap-changecoverimageconfirmation").removeClass("disabled"),$('label[for="snap-coverfiles"]').removeClass("state-visible"),$("#snap-changecoverimageconfirmation").addClass("state-visible"),$("body").removeClass("cover-image-change")},moodledialogue=function(courseShortName,categoryId,fpoptions,siteMaxBytes){var size,i,maxbytesstr=(size=siteMaxBytes,i=Math.floor(Math.log(size)/Math.log(1024)),1*(size/Math.pow(1024,i)).toFixed(2)+" "+["B","kB","MB","GB","TB"][i]);let title=M.util.get_string("imageproperties","theme_snap"),content='<div class="mb-1 snap_cover_image_dialogue"><p class="snap_cover_image_description">'+M.util.get_string("coverimagedesc","theme_snap",maxbytesstr)+'</p><div class="input-group input-append w-100 snap_cover_image_browser_options"><button class="btn btn-secondary snap_cover_image_browser" id="id_snap_cover_image_browser">'+M.util.get_string("browserepositories","theme_snap")+'</button></div><div class="mdl-align"><div class="snap_cover_image_preview_box"><img id="id_snap_cover_image_preview" class="snap_cover_image_preview" alt="" style="display: none;"/></div></div><div class="snap_cover_image_save"><button class="btn btn-secondary snap_cover_image_save_button" id="id_snap_cover_image_save_button"disabled>'+M.util.get_string("saveimage","theme_snap")+"</button></div></div>";var dialogue=new M.core.dialogue({headerContent:title,bodyContent:content,width:"600px",modal:!0,visible:!1,render:!0,additionalBaseClass:"snap_cover_image_dialogue"});dialogue.show(),$("body").addClass("cover-image-change"),$('label[for="snap-coverfiles"]').addClass("ajaxing"),$("#id_snap_cover_image_browser").click((function(e){e.preventDefault(),showFilepicker("image",fpoptions,filepickerCallback(courseShortName,categoryId))})),$("#id_snap_cover_image_save_button").click((function(){dialogue.hide()})),$(".snap_cover_image_dialogue .closebutton, .moodle-dialogue-lightbox").click((function(){state1()})),dialogue.after("visibleChange",(function(){$("#snap-changecoverimageconfirmation .ok").hasClass("ajaxing")&&state2(),dialogue.get("visible")||dialogue.destroy(!0)}))},filepickerCallback=function(courseShortName,categoryId){return function(params){""!==params.url&&function(params,courseShortName,categoryId){var image=new Image;image.onerror=function(){document.getElementById("id_snap_cover_image_preview").setAttribute("style","display:none")},image.onload=function(){var input,imageWidth=this.width;(input=document.getElementById("id_snap_cover_image_preview")).setAttribute("src",params.url),input.setAttribute("style","display:inline"),$(".snap_cover_image_save_button").prop("disabled",!1),imageWidth<1024?($("#snap-alert-cover-image-size").remove(),addCoverImageAlert("snap-alert-cover-image-size",M.util.get_string("error:coverimageresolutionlow","theme_snap"),"dialogue")):$("#snap-alert-cover-image-size").remove(),$("#id_snap_cover_image_save_button").click((function(){$(".path-course-view #page-header").addClass("mast-image"),$(".path-course-view #page-header .breadcrumb-item a").addClass("mast-breadcrumb"),$("#page-header").css("background-image","url("+params.url+")"),state2(),saveImage(params,courseShortName,categoryId)}))},image.src=params.url}(params,courseShortName,categoryId)}},showFilepicker=function(type,fpoptions,callback){Y.use("core_filepicker",(function(Y){var options=fpoptions;options.formcallback=callback,M.core_filepicker.show(Y,options)}))},saveImage=function(params,courseShortName,categoryId){$("#snap-changecoverimageconfirmation .ok").click((function(){var ajaxParams={};if(null!==categoryId)ajaxParams.categoryid=categoryId;else{if(null===courseShortName)return;ajaxParams.courseshortname=courseShortName}if(void 0!==params.id)ajaxParams.fileid=params.id;else{var fileNameWithoutSpaces=params.file.replace(/ .*/,""),regex=new RegExp("draft\\/(\\d+)\\/"+fileNameWithoutSpaces,"g"),urlId=params.url.match(regex);ajaxParams.fileid=urlId[0].match(/\d+/)[0]}ajaxParams.imagefilename=params.file,ajax.call([{methodname:"theme_snap_cover_image",args:{params:ajaxParams},done:function(response){state1(),response.contrast&&addCoverImageAlert("snap-alert-cover-image-size",response.contrast),!response.success&&response.warning&&addCoverImageAlert("snap-alert-cover-image-upload-failed",response.warning),$("#snap-changecoverimageconfirmation .ok").off("click")},fail:function(response){state1(),ajaxNotify.ifErrorShowBestMsg(response)}}],!0,!0)})),$("#snap-changecoverimageconfirmation .cancel").click((function(){$(this).parent().hasClass("disabled")||($("#page-header").css("background-image",$("#page-header").data("servercoverfile")),$(".path-course-view #page-header").removeClass("mast-image"),state1())}))},coverImage=function(ajaxParams){let courseShortName=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,categoryId=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,siteMaxBytes=arguments.length>3?arguments[3]:void 0;null===courseShortName&&null===categoryId||ajax.call([{methodname:"theme_snap_file_manager_options",args:[],done:function(data){var fpoptions=JSON.parse(data.fpoptions);$("#page-header").data("servercoverfile",$("#page-header").css("background-image")),$("#snap-coverimagecontrol").addClass("snap-js-enabled"),$("#snap-coverfiles").click((function(){moodledialogue(courseShortName,categoryId,fpoptions,siteMaxBytes)}))},fail:function(){}}],!0,!0)};return{courseImage:function(courseShortName,siteMaxBytes){coverImage({imagefilename:null,imagedata:null,categoryid:null,courseshortname:courseShortName},courseShortName,null,siteMaxBytes)},categoryImage:function(categoryId,siteMaxBytes){coverImage({imagefilename:null,imagedata:null,categoryid:categoryId,courseshortname:null},null,categoryId,siteMaxBytes)}}}));

//# sourceMappingURL=cover_image.min.js.map