/**
 * This file is part of Moodle - http://moodle.org/
 *
 * Moodle is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Moodle is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Moodle. If not, see <http://www.gnu.org/licenses/>.
 *
 * @package
 * @author    Oscar Nadjar oscar.nadjar@openlms.net
 * @copyright Copyright (c) 2019 Open LMS (https://www.openlms.net)
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("theme_snap/accessibility",["jquery","core/str","core/event"],(function($,str,Event){return{snapAxInit:function(localJouleGrader,allyReport,blockReports,localCatalogue){function Tabpanel(id){this._id=id,this.$tpanel=$("#"+id),this.$tabs=this.$tpanel.find(".tab"),this.$panels=this.$tpanel.find(".tab-pane"),this.bindHandlers(),this.init()}str.get_strings([{key:"accessforumstringdis",component:"theme_snap"},{key:"accessforumstringmov",component:"theme_snap"},{key:"calendar",component:"calendar"},{key:"accessglobalsearchstring",component:"theme_snap"},{key:"viewcalendar",component:"theme_snap"},{key:"viewmyfeedback",component:"theme_snap"},{key:"viewmessaging",component:"theme_snap"},{key:"viewforumposts",component:"theme_snap"},{key:"editcoursesettings",component:"theme_snap"},{key:"gradebook",component:"local_joulegrader"},{key:"gradebook",component:"core_grades"},{key:"numparticipants",component:"core_message"},{key:"pld",component:"theme_snap"},{key:"competencies",component:"core_competency"},{key:"outcomes",component:"core_outcome"},{key:"badges",component:"core_badges"},{key:"coursereport",component:"report_allylti"},{key:"pluginname",component:"local_catalogue"},{key:"experimental",component:"block_reports"}]).done((function(stringsjs){$("#page-mod-forum-discuss")&&($("div[data-content='forum-discussion'] div.singleselect form.form-inline select.custom-select.singleselect").attr("aria-label",stringsjs[0]),$("div[data-content='forum-discussion'] div.movediscussionoption select.custom-select.urlselect").attr("aria-label",stringsjs[1])),$("i.fa-calendar").parent().attr("aria-label",stringsjs[2]),$("input[name='TimeEventSelector[calendar]']").attr("aria-label",stringsjs[2]);var searchbutton=$("#mr-nav .simplesearchform a.btn.btn-open");$(searchbutton).attr({title:stringsjs[3],"aria-label":stringsjs[3]}),$('#snap-pm-updates section a.snap-personal-menu-more small:contains("'+stringsjs[4]+'")').attr("id","snap-pm-deadline"),$('#snap-pm-updates section a.snap-personal-menu-more small:contains("'+stringsjs[5]+'")').attr("id","snap-pm-feedback"),$('#snap-pm-updates section a.snap-personal-menu-more small:contains("'+stringsjs[6]+'")').attr("id","snap-pm-messages"),$('#snap-pm-updates section a.snap-personal-menu-more small:contains("'+stringsjs[7]+'")').attr("id","snap-pm-forum-posts"),$.expr[":"].contains=$.expr.createPseudo((function(arg){return function(elem){return $(elem).text().toUpperCase().indexOf(arg.toUpperCase())>=0}}));var ctparticipantsnumber=stringsjs[11].split(" ");$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[8]+'")').attr("id","ct-course-settings"),$('section#coursetools ul#coursetools-list a:contains("'+ctparticipantsnumber[1]+'")').attr("id","ct-participants-number"),$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[12]+'")').attr("id","ct-pld"),$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[13]+'")').attr("id","ct-competencies"),$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[14]+'")').attr("id","ct-outcomes"),$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[15]+'")').attr("id","ct-badges"),localJouleGrader?($('section#coursetools ul#coursetools-list a:contains("Open Grader")').attr("id","ct-open-grader"),$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[9]+'")').attr("id","ct-course-gradebook")):$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[10]+'")').attr("id","ct-course-gradebook"),blockReports&&($('section#coursetools ul#coursetools-list a:contains("Open Reports")').attr("id","ct-open-reports"),$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[18]+'")').attr("id","ct-open-reports-experimental")),allyReport&&$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[16]+'")').attr("id","ct-ally"),localCatalogue&&$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[17]+'")').attr("id","ct-open-catalogue"),$('div[role="main"] div.sitetopic ul.section.img-text').attr("role","presentation")})),$(document).ready((function(){$("#page-mod-data-edit input[id*='url']").attr("type","url").attr("autocomplete","url"),$("#moodle-blocks aside#block-region-side-pre a.sr-only.sr-only-focusable").attr("tabindex","-1"),$(".mform").submit((function(){$("input.form-control.is-invalid:first").focus()}));var addtext=$('.groupmanagementtable #buttonscell p.arrow_button input[name="add"]').attr("value"),removetext=$(".groupmanagementtable #buttonscell p.arrow_button input[name='remove']").attr("value");new Tabpanel("snap-pm-accessible-tab"),new Tabpanel("modchooser-accessible-tab"),0==$(".dropdown-item.editing_pld").closest(".pld-dropdown").length&&$(".dropdown-item.editing_pld").wrap("<li class='pld-dropdown'></li>"),$(".dropdown-item.editing_pld").attr("role","button");var $window=$(window);function checkWidth(){var windowsize=$window.width();windowsize<1220?($(".groupmanagementtable #buttonscell p.arrow_button input[name='add']").attr("value","+"),$(".groupmanagementtable #buttonscell p.arrow_button input[name='remove']").attr("value","-")):windowsize>1220&&($(".groupmanagementtable #buttonscell p.arrow_button input[name='add']").attr("value",addtext),$(".groupmanagementtable #buttonscell p.arrow_button input[name='remove']").attr("value",removetext))}checkWidth(),$(window).resize(checkWidth),function(){var carouselindicator=$("#snap-site-carousel .carousel-indicators button");carouselindicator.click((function(e){var element=$(e.target);carouselindicator.attr("aria-current",!1),element.attr("aria-current",!0)}));var targetNode=document.getElementById("snap-carousel-container"),observer=new MutationObserver((()=>{$(".carousel-indicators button").attr("aria-current",!1),$(".carousel-indicators button.active").attr("aria-current",!0)}));targetNode&&observer.observe(targetNode,{attributes:!0,childList:!0,subtree:!0})}(),$("#snap-site-carousel").carousel({interval:6e3,pause:"false"}),$("#play-button").click((function(){$("#snap-site-carousel").carousel("cycle")})),$("#pause-button").click((function(){$("#snap-site-carousel").carousel("pause")}))})),Tabpanel.prototype.keys={left:37,up:38,right:39,down:40},Tabpanel.prototype.init=function(){var $tab;this.$panels.attr("aria-hidden","true"),this.$panels.removeClass("active in"),void 0===($tab=this.$tabs.filter(".active"))&&($tab=this.$tabs.first()).addClass("active"),this.$tpanel.find("#"+$tab.find("a").attr("aria-controls")).addClass("active in").attr("aria-hidden","false")},Tabpanel.prototype.switchTabs=function($curTab,$newTab){var $curTabLink=$curTab.find("a"),$newTabLink=$newTab.find("a");$curTab.removeClass("active"),$curTabLink.attr("tabindex","-1").attr("aria-selected","false"),$newTab.addClass("active"),$newTabLink.attr("aria-selected","true"),this.$tpanel.find("#"+$curTabLink.attr("aria-controls")).removeClass("active in").attr("aria-hidden","true"),this.$tpanel.find("#"+$newTabLink.attr("aria-controls")).addClass("active in").attr("aria-hidden","false"),$newTabLink.attr("tabindex","0"),$newTabLink.focus()},Tabpanel.prototype.bindHandlers=function(){var self=this;this.$tabs.keydown((function(e){return self.handleTabKeyDown($(this),e)})),this.$tabs.click((function(e){return self.handleTabClick($(this),e)}))},Tabpanel.prototype.handleTabKeyDown=function($tab,e){var $newTab,tabIndex;switch(e.keyCode){case this.keys.left:case this.keys.up:return $newTab=0===(tabIndex=this.$tabs.index($tab))?this.$tabs.last():this.$tabs.eq(tabIndex-1),this.switchTabs($tab,$newTab),e.preventDefault(),!1;case this.keys.right:case this.keys.down:return $newTab=(tabIndex=this.$tabs.index($tab))===this.$tabs.length-1?this.$tabs.first():this.$tabs.eq(tabIndex+1),this.switchTabs($tab,$newTab),e.preventDefault(),!1}},Tabpanel.prototype.handleTabClick=function($tab){var $oldTab=this.$tpanel.find(".tab.active");this.switchTabs($oldTab,$tab)}},enhanceform:function(elementid){var element=document.getElementById(elementid);$(element).on(Event.Events.FORM_FIELD_VALIDATION,(function(event,msg){event.preventDefault();var parent=$(element).closest(".form-group"),feedback=parent.find(".form-control-feedback"),invalidinput=parent.find("input.form-control.is-invalid");"TEXTAREA"==$(element).prop("tagName")&&parent.find("[contenteditable]")&&(element=parent.find("[contenteditable]")),""!==msg?(parent.addClass("has-danger"),parent.data("client-validation-error",!0),$(element).addClass("is-invalid"),$(element).attr("aria-describedby",feedback.attr("id")),$(element).attr("aria-invalid",!0),invalidinput.attr("tabindex",0),feedback.html(msg),feedback.is(":visible")||(feedback.show(),feedback.focus())):!0===parent.data("client-validation-error")&&(parent.removeClass("has-danger"),parent.data("client-validation-error",!1),$(element).removeClass("is-invalid"),$(element).removeAttr("aria-describedby"),$(element).attr("aria-invalid",!1),feedback.hide())}))}}}));

//# sourceMappingURL=accessibility.min.js.map